
import sys
import os
import time
import re
import struct
import datetime
from pywinusb import hid
 

def chunks(l, n):
    """Yield successive n-sized chunks from l."""
    for i in range(0, len(l), n):
        yield l[i:i + n]


class antscope:
     
    def __deinit__(self):
        self.close()
    
    def __init__(self):
        self.cache =[]
        self.sbuf =''
        self.pickup = False
        self.proceed = False
        self.lines =[]
        pass
        
    
    def open(self):
        filter = hid.HidDeviceFilter(vendor_id = 0x0483, product_id = 0xa1de)
        devices = filter.get_devices()

        if not devices:
            return False

        self.device = False
        self.report = False
            
        for dev in devices:
            dev.open()
            for rep in dev.find_output_reports():
                if rep.report_id == 7:
                    self.device = dev
                    self.report = rep
                    
            if self.report:
                break
            else:
                dev.close()       
                    
        if not(self.device and self.report):
            return False

        print ("Device was found..")           
        self.device.set_raw_data_handler(self._rxHandler)
        self.errorcode = 0       
        return True
        

    def close(self):
        self.device.close()
        
        
    def _rxHandler(self, data):
        chunk  = bytes(data[2:(data[1]+2)]).decode()
        self.lines.append(chunk)
        print(chunk, end='', flush=True)
        if self.pickup:
            self.sbuf+=chunk
            items = self.sbuf.split('\r\n')
            self.cache.extend(items[:-1])
            self.sbuf = items[-1]
            if 'OK' in self.cache[-1]:
                self.proceed = True

     
    def cmdSendCommand(self, data):
        print ('Request:{0}'.format(data))
        dataList = [7,len(data)]+list(ord(s) for s in list(data)) + [0]*65	
        self.report.send(dataList[:64])        
        
    def cmdSendBinary(self, data):
        print ('BIN OUT:' + self.printHexArr(data))
        datatosend = [7,len(data)]+ data + [0]*65
        self.report.send(datatosend[:64])
        
    def printHexArr(self,data):
        res =[]
        res.append('[')
        res.append(','.join('0x{:02X}'.format(x) for x in data))
        res.append(']')
        return ''.join(res)
    
    def make_report(self):
        pass  
#-----------------------------------
def flush_lines(arr):
    for item in arr:
        print(item, end='', flush=True)
    arr.clear()
#-----------------------------------
def main():
    device = antscope()
   
    if device.open():
        #power = 0       # this line tries to switch off
        power = 1       # this line tries to switch on
        cmd = 'PSW{0}\r\n'.format(power)
        device.cmdSendCommand(cmd)
        time.sleep(5)
    else:
        print('Device not found!')
    
    


if __name__ == '__main__':   
    main()

    
